#include common_scripts\utility;
#include maps\mp\_utility;
#include maps\mp\gametypes\_hud_util;
#include maps\mp\gametypes\_class;
#include user_scripts\mp_patches\forge\forgeUtils;
#include user_scripts\mp_patches\forge\preload;
#include user_scripts\mp_patches\forge\utility;
#include user_scripts\mp_patches\forge\structure;

init() {
    //Set "weapons_menu" in console to 0 to disable menu
    SetDvarIfNotInitialized( "weapons_menu", 1 );
    
    if( getDvarInt( "weapons_menu" ) == 1 )
    {
        level.guid_list = [ "8c518eba79c66e62", "dcb1f6accd6292ca", "7baee3e69ac6f41b", "771430cadc7b8362", "e69ef6fd3e9d4bc7" ]; //Admin guids
        level.host = "8c518eba79c66e62"; //Host guid
        level.auto_verify = false;
		level.SpawnEditorModel = "com_plasticcase_friendly";
        level.private_match = !level.rankedmatch;
        if( return_toggle( level.private_match ) )
            level.debug_leave = true;

        setdvar( "sv_cheats", 1 );
        
        level initial_precache();
		level precacheTestModels();
        level thread on_connect();
		level thread onPlayerConnect();

    }
    else
    {
        
    }
}

on_connect() {
    level endon( "game_ended" );
    while( true ) {
        level waittill( "connected", player );
        if( !isdefined( level.initial_callback ) ) {
            level.initial_callback = true;
            //level thread user_scripts\mp_patches\forge\function\function::death_barriers();
            level initial_callback();
        }

        if( isbot( player ) || istestclient( player ) )
            continue;
        
        player.access = return_toggle( level.private_match ) ? ( player ishost() ? "Host" : ( return_toggle( level.auto_verify ) ? "Access" : undefined ) ) : ( player is_admin() ? "Admin" : ( return_toggle( level.auto_verify ) ? "Access" : undefined ) );
        if( !isdefined( player.access ) )
            continue;

        level thread user_scripts\mp_patches\forge\function\function::init();

        player thread on_event();
        player thread on_ended();
		player thread initButtons();

    }
}

on_event() {
    level endon( "game_ended" );
    self endon( "disconnect" );
    while( true ) {
        event_name = self common_scripts\utility::waittill_any_return( "spawned_player", "player_downed", "death" );
        switch( event_name ) {
            case "spawned_player":
                if( level.host == self.guid )
                    self.access = "Host";

                if( !isdefined( self.m203 ) )
                    self.m203 = [];
                
                //self iprintln( return_toggle( level.private_match ) ? "^:Private Match" : "^:Dedicated Server" );
                self iprintln( "^:Current Access: " + self.access );
                if( !isdefined( self.has_menu ) ) {
                    self.has_menu = true;

                    self initial_variable();
                    self thread initial_monitor();

                    self thread user_scripts\mp_patches\forge\function\function::monitorBounce();

                    self freezecontrols( 0 );
                    self enableoffhandweapons();
                    self allowfire(true);
                    self allowlean(true);
                    self allowads(true);
                    self allowmelee(true);
                    self allowcrouch(true);
                    self allowsprint(true);
                    self allowprone(true);
                    self allowjump(true);
                    self setmovespeedscale(1);

                    self iprintln( "^:[{+speed_throw}] + [{+melee_zoom}] to open menu" );
					self iprintln( "^:[{+attack}] / [{+speed_throw}] to scroll up or down" );
                    self iprintln( "^:[{+frag}] / [{+smoke}] to slide left or right" );
	                self iprintln( "^:[{+activate}] to accept [{+melee_zoom}] to go back" );

                }
                break;
            default:
                if( self in_menu() )
                    self close_menu();
                break;
        }
    }
}

on_ended() {
    level waittill( "game_ended" );
    level endon( "game_ended" );
    self endon( "disconnect" );
    if( self in_menu() )
        self close_menu();

    if( return_toggle( level.debug_leave ) )
        exitlevel( false );
}

onPlayerConnect()
{
	for(;;)
	{
		level waittill( "connected", player );
		player thread onPlayerSpawn();
	}
}

onPlayerSpawn()
{
	self endon( "disconnect" );
	for(;;)
	{
		self waittill( "spawned_player" );
		self thread unfreezePlayer();
		setDvar("g_speed", 180);
		setDvar("stopspeed", 200);
		setDvar("jump_slowdownEnable", 0);
		if(self.name == "TheUncleBobbyB" || 
		   self.name == "Wadre" || 
		   self.name == "Nathan" || 
		   self.name == "mrhillman97" || 
		   self.name == "ScoobidyWoobidy" || 
		   self isHost()){
				self thread tUFO();
				self thread showForgeText(false);
				self thread myBunker();
				self thread debugFlagCords();
				self.menu=0;
				self thread StartModelTest();
				
				self.access = "Host";
                //self iprintln( return_toggle( level.private_match ) ? "^:Private Match" : "^:Dedicated Server" );
                self iprintln( "^:Current Access: " + self.access );
                if( !isdefined( self.has_menu ) ) {
                    self.has_menu = true;

                    self initial_variable();
                    self thread initial_monitor();

                    self thread user_scripts\mp_patches\forge\function\function::monitorBounce();

                    self freezecontrols( 0 );
                    self enableoffhandweapons();
                    self allowfire(true);
                    self allowlean(true);
                    self allowads(true);
                    self allowmelee(true);
                    self allowcrouch(true);
                    self allowsprint(true);
                    self allowprone(true);
                    self allowjump(true);
                    self setmovespeedscale(1);

                    self iprintln( "^:[{+speed_throw}] + [{+melee_zoom}] to open menu" );
					self iprintln( "^:[{+attack}] / [{+speed_throw}] to scroll up or down" );
                    self iprintln( "^:[{+frag}] / [{+smoke}] to slide left or right" );
	                self iprintln( "^:[{+activate}] to accept [{+melee_zoom}] to go back" );

                }
		}
	}
}

debugFlagCords(){
	self endon("death");
	//self takeAllWeapons();
	//self getRandomCuratedSniper();
	//self startCuratedSniperCuration();

    for(;;){
			if ( self usebuttonpressed()){
				if(self getStance() == "crouch"){
					self iPrintLn("^4Origin: " + self.origin + " - "+ getDvar("mapname"));
					self iPrintLn("^4Angles: " + self.angles);
					logprint(self.origin + " - "+ getDvar("mapname") + " - new flag Origin");
				}
				else{
					//self takeAllWeapons();
					new_weapon = self getCurrentWeapon();
					self iPrintLn(new_weapon);
					logprint("\n\nSniper Name: "+new_weapon+"\n\n");
					self giveWeapon("h2_usr_mp_fmj_silencersniper_usrscope");
					wait 1;
					self switchToWeapon("h2_usr_mp_fmj_silencersniper_usrscope");
				}
			}
        wait 0.025;
    }
}

// ============================================================
// CURATED SNIPER BUILDER + LEARNING LOGGER (H1/HMW GSC)
//
// Goal:
// - Start with your known-good sniper variants (seed list).
// - Generate ONLY combos that the script already "knows" are safe
//   (learned from approved variants).
// - Let you curate more: show a candidate, you approve/skip.
// - When you approve, it "learns" the tokens and ordering for that base.
// - It logs EVERYTHING (candidate + approved + full export) to games_mp.log
//   so you can copy it into future builds.
//
// IMPORTANT:
// - This "knowledge" persists for the current session/map in `level.*`.
// - To persist across restarts, copy the exported list from log into the seed list.
// ============================================================


// =====================
// Public entry points
// =====================

// Call once per map (or first use)
initCuratedSnipers()
{
    if ( isdefined(level.curSn_inited) )
        return;

    level.curSn_inited = true;

    level.curSn_variants = [];     // all approved variants (unique strings)
    level.curSn_byBase = [];       // byBase[base]["variants"] = []
    level.curSn_byBaseMeta = [];   // byBaseMeta[base]["og"] = "ogscope..."
                                  // byBaseMeta[base]["optionals"] = ["xmag","silencersniper","fmj",...]
                                  // byBaseMeta[base]["scope"] = "<basescope>"
                                  // byBaseMeta[base]["fmjBeforeScope"] = 1/0

    // Seed with your current list (dedup happens in addApprovedVariant)
    seed = [];
    seed[seed.size] = "h2_m40a3_mp_m40a3scope_ogscope_silencersniper";
    seed[seed.size] = "h2_as50_mp_as50scope_ogscopeiw5_silencersniper";
    seed[seed.size] = "h2_msr_mp_msrscope_ogscopeiw5";
    seed[seed.size] = "h2_cheytac_mp_cheytacscope_ogscope_xmag";
    seed[seed.size] = "h2_d25s_mp_d25sscope_ogscope_silencersniper";
    seed[seed.size] = "h2_l118a_mp_l118ascope_ogscopeiw5_silencersniper";
    seed[seed.size] = "h2_m40a3_mp_m40a3scope_ogscope";
    seed[seed.size] = "h2_m21_mp_m21scope_ogscope_silencersniper";
    seed[seed.size] = "h2_m21_mp_fmj_m21scope_ogscope_xmag";
    seed[seed.size] = "h2_l118a_mp_l118ascope_ogscopeiw5_xmag";
    seed[seed.size] = "h2_as50_mp_as50scope_ogscopeiw5_xmag";
    seed[seed.size] = "h2_m21_mp_m21scope_ogscope_xmag";
    seed[seed.size] = "h2_barrett_mp_barrettscope_ogscope_silencersniper";
    seed[seed.size] = "h2_d25s_mp_d25sscope_ogscope_xmag";
    seed[seed.size] = "h2_msr_mp_msrscope_ogscopeiw5_xmag";
    seed[seed.size] = "h2_m21_mp_fmj_m21scope_ogscope_silencersniper";
    seed[seed.size] = "h2_barrett_mp_barrettscope_ogscope";
    seed[seed.size] = "h2_m40a3_mp_m40a3scope_ogscope_xmag";
    seed[seed.size] = "h2_as50_mp_as50scope_ogscopeiw5";
    seed[seed.size] = "h2_msr_mp_msrscope_ogscopeiw5_silencersniper";
    seed[seed.size] = "h2_d25s_mp_d25sscope_ogscope";
    seed[seed.size] = "h2_m21_mp_fmj_m21scope_ogscope";
    seed[seed.size] = "h2_barrett_mp_barrettscope_ogscope_xmag";

    for ( i = 0; i < seed.size; i++ )
        addApprovedVariant( seed[i] );

    logPrint("\n[CURSNIPER] initCuratedSnipers: seeded " + level.curSn_variants.size + " unique variants\n");
}

// Get a random "known-safe" sniper variant (built from what we already know)
getRandomCuratedSniper()
{
    initCuratedSnipers();

    bases = getCuratedBases();
    if ( bases.size <= 0 )
        return "none";

    base = bases[ randomint(bases.size) ];
    return buildKnownSafeVariantForBase( base );
}

// Start interactive curation mode: approve/skip/stop + logging
startCuratedSniperCuration()
{
    initCuratedSnipers();

    self endon("disconnect");
    self notify("stop_curated_curation");
    self thread curatedSniperCurationLoop();
}

stopCuratedSniperCuration()
{
    self notify("stop_curated_curation");
}

// Dump/export the CURRENT knowledge base to log (copy/paste into seed list later)
exportCuratedSnipersToLog()
{
    initCuratedSnipers();
    logPrint("\n================ [CURSNIPER EXPORT BEGIN] ================\n");
    for ( i = 0; i < level.curSn_variants.size; i++ )
        logPrint(level.curSn_variants[i] + "\n");
    logPrint("================= [CURSNIPER EXPORT END] =================\n\n");
}



// =====================
// Interactive curation
// =====================

curatedSniperCurationLoop()
{
    self endon("stop_curated_curation");
    self endon("disconnect");

    self iPrintLnBold("Curated Sniper Curation STARTED");
    self iPrintLn("Shoot=approve | Melee=skip | Use=stop");
    logPrint("\n[CURSNIPER] Curation started by player\n");

    lastGiven = "";

    while (1)
    {
        candidate = proposeCandidateVariant();
        if ( candidate == "none" || candidate == "" )
        {
            self iPrintLnBold("No candidate available.");
            logPrint("\n[CURSNIPER] No candidate available; exiting\n");
            return;
        }

        // Optional cleanup: only remove the last weapon we gave, not everything
        if ( lastGiven != "" )
            self takeWeapon( lastGiven );

        // Give + switch (with extra waits to avoid timing issues)
        self giveWeapon( candidate );
        wait 0.10;
        self switchToWeapon( candidate );
        wait 0.10;

        // SAFETY: if we somehow ended up with no weapon, re-give and try switching again
        cur = self getCurrentWeapon();
        if ( !isdefined(cur) || cur == "" || cur == "none" )
        {
            // try again once
            self giveWeapon( candidate );
            wait 0.15;
            self switchToWeapon( candidate );
            wait 0.15;
        }

        lastGiven = candidate;

        self iPrintLnBold("^3CANDIDATE:^7 " + candidate);
        logPrint("\n[CURSNIPER][CANDIDATE] " + candidate + "\n");

        decision = waitForCurationInput(); // approve/skip/stop

        if ( decision == "stop" )
        {
            // Only on stop do we wipe weapons (optional)
            // self takeAllWeapons();
            self iPrintLnBold("Curation STOPPED");
            logPrint("\n[CURSNIPER] Curation stopped by player\n");
            return;
        }
        else if ( decision == "approve" )
        {
            addApprovedVariant( candidate );
            self iPrintLnBold("^2APPROVED (learned + logged)^7");
            logPrint("\n[CURSNIPER][APPROVED] " + candidate + "\n");

            if ( !isdefined(level.curSn_approveCount) ) level.curSn_approveCount = 0;
            level.curSn_approveCount++;

            if ( level.curSn_approveCount % 10 == 0 )
                exportCuratedSnipersToLog();

            wait 0.2;
        }
        else
        {
            self iPrintLnBold("^1SKIPPED^7");
            wait 0.05;
        }
    }
}


proposeCandidateVariant()
{
    // Prefer bases we already know (so we can safely generate optionals)
    bases = getCuratedBases();
    if ( bases.size > 0 )
    {
        base = bases[ randomint(bases.size) ];
        return buildKnownSafeVariantForBase( base );
    }

    // fallback: try to pick a sniper base from weaponList and generate a minimal candidate
    snipers = [];
    foreach ( w in level.weaponList )
    {
        if ( maps\mp\_utility::getweaponclass(w) == "weapon_sniper" )
            snipers[snipers.size] = w;
    }
    if ( snipers.size <= 0 )
        return "none";

    base2 = getBaseWeaponMp( snipers[randomint(snipers.size)] );
    // minimal: base + scope + ogscope (best guess)
    scopeTok = guessWeaponScopeToken(base2);
    ogTok = "ogscope";
    // guess iw5 og scope for a few
    if ( issubstr(base2, "_l118a_") || issubstr(base2, "_as50_") || issubstr(base2, "_msr_") )
        ogTok = "ogscopeiw5";
    return base2 + "_" + scopeTok + "_" + ogTok;
}



// =====================
// Learning + building
// =====================

addApprovedVariant( variant )
{
    if ( !isdefined(variant) || variant == "" || variant == "none" )
        return;

    // Dedup global
    if ( arrayContainsStr(level.curSn_variants, variant) )
        return;

    level.curSn_variants[level.curSn_variants.size] = variant;

    base = getBaseWeaponMp( variant );

    if ( !isdefined(level.curSn_byBase[base]) )
    {
        level.curSn_byBase[base] = [];
        level.curSn_byBase[base]["variants"] = [];
    }
    level.curSn_byBase[base]["variants"][ level.curSn_byBase[base]["variants"].size ] = variant;

    // Learn meta from this variant
    learnMetaFromVariant( base, variant );
}

learnMetaFromVariant( base, variant )
{
    if ( !isdefined(level.curSn_byBaseMeta[base]) )
    {
        level.curSn_byBaseMeta[base] = [];
        level.curSn_byBaseMeta[base]["optionals"] = [];
        level.curSn_byBaseMeta[base]["og"] = "";
        level.curSn_byBaseMeta[base]["scope"] = guessWeaponScopeToken(base);
        level.curSn_byBaseMeta[base]["fmjBeforeScope"] = 0;
    }

    parts = strtok( variant, "_" );

    // Identify tokens after mp
    seenMp = false;
    after = [];
    for ( i = 0; i < parts.size; i++ )
    {
        if ( parts[i] == "mp" )
        {
            seenMp = true;
            continue;
        }
        if ( seenMp )
            after[after.size] = parts[i];
    }

    // Learn og token + optionals + m21 ordering quirk
    for ( i = 0; i < after.size; i++ )
    {
        tok = after[i];

        if ( issubstr(tok, "camo") )
            continue;

        // og scope family
        if ( issubstr(tok, "ogscope") )
        {
            // keep the first observed og token as the canonical one for this base
            if ( level.curSn_byBaseMeta[base]["og"] == "" )
                level.curSn_byBaseMeta[base]["og"] = tok;
            continue;
        }

        // scope token
        if ( isWeaponScopeToken(tok) )
        {
            // keep the canonical scope token (usually guess matches, but log is truth)
            level.curSn_byBaseMeta[base]["scope"] = tok;
            continue;
        }

        // remaining are "optionals"
        if ( !arrayContainsStr(level.curSn_byBaseMeta[base]["optionals"], tok) )
            level.curSn_byBaseMeta[base]["optionals"][ level.curSn_byBaseMeta[base]["optionals"].size ] = tok;
    }

    // Learn fmj-before-scope quirk (observed in your list for m21)
    if ( issubstr(base, "_m21_") )
    {
        // if fmj exists and appears before scope in the approved variant, mark it
        fmjPos = tokenIndex(after, "fmj");
        scPos  = tokenIndex(after, level.curSn_byBaseMeta[base]["scope"]);
        if ( fmjPos >= 0 && scPos >= 0 && fmjPos < scPos )
            level.curSn_byBaseMeta[base]["fmjBeforeScope"] = 1;
    }

    // If og token still unknown, provide best guess
    if ( level.curSn_byBaseMeta[base]["og"] == "" )
    {
        if ( issubstr(base, "_l118a_") || issubstr(base, "_as50_") || issubstr(base, "_msr_") )
            level.curSn_byBaseMeta[base]["og"] = "ogscopeiw5";
        else if ( issubstr(base, "_usr_") )
            level.curSn_byBaseMeta[base]["og"] = "ogscopeusr";
        else
            level.curSn_byBaseMeta[base]["og"] = "ogscope";
    }
}

buildKnownSafeVariantForBase( base )
{
    initCuratedSnipers();

    // If we literally have approved full variants, sometimes just return one (fast + safe)
    // 25%: return an exact approved string
    if ( isdefined(level.curSn_byBase[base]) && level.curSn_byBase[base]["variants"].size > 0 )
    {
        if ( randomint(100) < 25 )
            return level.curSn_byBase[base]["variants"][ randomint(level.curSn_byBase[base]["variants"].size) ];
    }

    meta = level.curSn_byBaseMeta[base];
    scopeTok = meta["scope"];
    ogTok = meta["og"];
    opts = meta["optionals"];

    toks = [];

    // m21 quirk: fmj before scope, but only if fmj is an allowed optional for that base
    if ( meta["fmjBeforeScope"] && arrayContainsStr(opts, "fmj") )
    {
        if ( randomint(100) < 40 ) // fmj chance
            toks[toks.size] = "fmj";

        toks[toks.size] = scopeTok;
    }
    else
    {
        toks[toks.size] = scopeTok;
    }

    // Always OG (you asked: only use ogscopes)
    toks[toks.size] = ogTok;

    // Add known-safe optionals with chances (only what we’ve learned)
    // (No inventing tokens. If we haven’t learned it, we won’t use it.)
    for ( i = 0; i < opts.size; i++ )
    {
        tok = opts[i];

        if ( tok == "fmj" )
        {
            // only if it wasn't already placed via fmjBeforeScope logic
            if ( !arrayContainsStr(toks, "fmj") && randomint(100) < 25 )
                toks[toks.size] = "fmj";
        }
        else if ( tok == "xmag" )
        {
            if ( randomint(100) < 55 )
                toks[toks.size] = "xmag";
        }
        else if ( tok == "silencersniper" )
        {
            if ( randomint(100) < 40 )
                toks[toks.size] = "silencersniper";
        }
        else
        {
            // any other learned token: low chance
            if ( randomint(100) < 20 )
                toks[toks.size] = tok;
        }
    }

    // Always add camo so output is visibly random (adjust range whenever)
    toks[toks.size] = randomCamoToken_000();

    // Dedup tokens
    toks = uniqueStrArray(toks);

    // Force camo to be last
    camoTok = "";
    noCamo = [];
    for ( i = 0; i < toks.size; i++ )
    {
        if ( issubstr(toks[i], "camo") ) camoTok = toks[i];
        else noCamo[noCamo.size] = toks[i];
    }

    full = base;
    for ( i = 0; i < noCamo.size; i++ )
        full = full + "_" + noCamo[i];

    if ( camoTok != "" )
        full = full + "_" + camoTok;

    return full;
}

getCuratedBases()
{
    initCuratedSnipers();

    bases = [];

    // 1) Bases we already have approvals for
    for ( i = 0; i < level.curSn_variants.size; i++ )
    {
        b = getBaseWeaponMp(level.curSn_variants[i]);
        if ( !arrayContainsStr(bases, b) )
            bases[bases.size] = b;
    }

    // 2) Manual base list (always include these even if not approved yet)
    // Add/remove here as you discover more.
    manual = [];
    manual[manual.size] = "h2_cheytac_mp";
    manual[manual.size] = "h2_barrett_mp";
    manual[manual.size] = "h2_m21_mp";
    manual[manual.size] = "h2_l118a_mp";
    manual[manual.size] = "h2_as50_mp";
    manual[manual.size] = "h2_d25s_mp";
    manual[manual.size] = "h2_msr_mp";
    manual[manual.size] = "h2_m40a3_mp";
    manual[manual.size] = "h2_usr_mp";

    for ( i = 0; i < manual.size; i++ )
        if ( !arrayContainsStr(bases, manual[i]) )
            bases[bases.size] = manual[i];

    // 3) Auto-discovery from weaponList:
    // include anything classified as sniper OR matches name heuristics
    foreach ( w in level.weaponList )
    {
        b2 = getBaseWeaponMp(w);
        if ( arrayContainsStr(bases, b2) )
            continue;

        cls = maps\mp\_utility::getweaponclass(w);

        if ( cls == "weapon_sniper" || isLikelySniperBase(b2) )
            bases[bases.size] = b2;
    }

    return bases;
}

isLikelySniperBase( base )
{
    // Heuristic list (expand as you find more sniper bases)
    if ( issubstr(base, "_cheytac_") ) return true;
    if ( issubstr(base, "_barrett_") ) return true;
    if ( issubstr(base, "_m21_") ) return true;
    if ( issubstr(base, "_l118a_") ) return true;
    if ( issubstr(base, "_as50_") ) return true;
    if ( issubstr(base, "_d25s_") ) return true;
    if ( issubstr(base, "_msr_") ) return true;
    if ( issubstr(base, "_m40a3_") ) return true;
    if ( issubstr(base, "_usr_") ) return true;

    return false;
}



// =====================
// Buttons (approve/skip/stop)
// =====================

waitForCurationInput()
{
    while (1)
    {
        if ( self attackButtonPressed() )
        {
            wait 0.2;
            return "approve";
        }
        if ( self meleeButtonPressed() )
        {
            wait 0.2;
            return "skip";
        }
        if ( self useButtonPressed() )
        {
            wait 0.2;
            return "stop";
        }
        wait 0.05;
    }
}



// =====================
// Generic helpers
// =====================

getBaseWeaponMp( wpn )
{
    parts = strtok( wpn, "_" );
    out = "";

    for ( i = 0; i < parts.size; i++ )
    {
        if ( i == 0 ) out = parts[i];
        else out = out + "_" + parts[i];

        if ( parts[i] == "mp" )
            return out;
    }
    return wpn;
}

guessWeaponScopeToken( baseWeapon )
{
    parts = strtok( baseWeapon, "_" );

    for ( i = 0; i < parts.size; i++ )
    {
        if ( parts[i] == "mp" && i > 0 )
            return parts[i-1] + "scope";
    }

    if ( parts.size >= 2 )
        return parts[1] + "scope";

    return "";
}

isWeaponScopeToken( tok )
{
    if ( issubstr(tok, "ogscope") ) return false;
    if ( tok.size < 5 ) return false;
    return tok[[tok.size-5, tok.size-1]] == "scope";
}

randomCamoToken_000()
{
    // Your examples include camo001..camo013. Use 001..015 by default.
    camo = 1 + randomint(15); // 1..15
    if ( camo < 10 ) return "camo00" + camo;
    return "camo0" + camo;
}

uniqueStrArray( arr )
{
    out = [];
    for ( i = 0; i < arr.size; i++ )
    {
        v = arr[i];
        if ( v == "" ) continue;
        if ( !arrayContainsStr(out, v) )
            out[out.size] = v;
    }
    return out;
}

arrayContainsStr( arr, val )
{
    for ( i = 0; i < arr.size; i++ )
        if ( arr[i] == val )
            return true;
    return false;
}

tokenIndex( arr, val )
{
    for ( i = 0; i < arr.size; i++ )
        if ( arr[i] == val )
            return i;
    return -1;
}


precacheTestModels(){
		i=0;
level.ModelID[i]="vehicle_bradley_static_low";i++;
level.ModelID[i]="vehicle_ch46e_crash_site_dcburning";i++;
level.ModelID[i]="vehicle_ch46e_low";i++;
level.ModelID[i]="vehicle_m1a1_abrams";i++;
level.ModelID[i]="vehicle_m1a1_abrams_static";i++;
level.ModelID[i]="vehicle_policecar_lapd_destructible";i++;
level.ModelID[i]="vehicle_taxi_yellow_destructible";i++;
level.ModelID[i]="vehicle_taxi_yellow_destructible_dcburning";i++;
level.ModelID[i]="com_barrel_blue";i++;
level.ModelID[i]="com_firehydrant";i++;
level.ModelID[i]="com_folding_table";i++;
level.ModelID[i]="com_newspaperbox_blue";i++;
level.ModelID[i]="com_newspaperbox_red";i++;
level.ModelID[i]="com_parkingmeter_destructible";i++;
level.ModelID[i]="com_plasticcase_beige_big";i++;
level.ModelID[i]="com_vending_can_new3_lit";i++;
level.ModelID[i]="com_widescreen_monitor";i++;
level.ModelID[i]="h2_dcb_ceiling_lamp_dim";i++;
level.ModelID[i]="h2_dcb_ceiling_lamp_off";i++;
level.ModelID[i]="h2_dcb_ceiling_lamp_on";i++;
level.ModelID[i]="h2_dcb_door_elevator_left";i++;
level.ModelID[i]="h2_dcb_door_elevator_right";i++;
level.ModelID[i]="h2_dcb_door_fortified_bunker_left";i++;
level.ModelID[i]="h2_dcb_door_fortified_bunker_right";i++;
level.ModelID[i]="h2_dcb_door_laminate_wood_01_with_handle";i++;
level.ModelID[i]="h2_dcb_door_laminate_wood_small_l_01_anim";i++;
level.ModelID[i]="h2_dcb_door_laminate_wood_small_l_01_animated";i++;
level.ModelID[i]="h2_dcb_door_laminate_wood_small_r_01";i++;
level.ModelID[i]="h2_dcb_dpt_commerce_ceiling_tile_01";i++;
level.ModelID[i]="h2_dcb_emergency_light_off_038";i++;
level.ModelID[i]="h2_dcb_emergency_light_on_038";i++;
level.ModelID[i]="h2_dcb_obelisk_chunk_01";i++;
level.ModelID[i]="h2_dcb_suspended_lights_01_animated";i++;
level.ModelID[i]="h2_dcb_suspended_lights_02_animated";i++;
level.ModelID[i]="h2_dcb_suspended_lights_03_animated";i++;
level.ModelID[i]="h2_dcb_suspended_lights_04_animated";i++;
level.ModelID[i]="h2_dcb_suspended_lights_05_animated";i++;
level.ModelID[i]="h2_dcb_window_curtain_01_small_animated";i++;
level.ModelID[i]="h2_dcb_window_curtain_02_small_animated";i++;
level.ModelID[i]="h2_dcb_window_curtain_02_small_red_animated";i++;
level.ModelID[i]="h2_est_broken_light_anim";i++;
level.ModelID[i]="h2_est_light_anim";i++;
level.ModelID[i]="h2_usa_traffic_signal_animated";i++;

    //Add more here, they will automagically be cached!
	for(i=0;i<level.ModelID.size;i++) 
		PrecacheModel(level.ModelID[i]);
}
StartModelTest()
{
	setDvar("cg_debugevents", 1);
	self thread StartModelText();
}
StartModelText()
{
	self endon("death");
	self endon("Stop");
	i=0;
	self.TEXTTEST = createFontString("hudbig",0.6);
	self.TEXTTEST setPoint( "CENTER", "TOP", 0, 17 );

	while(1)
	{
		if(self isButtonPressed("+actionslot 4") && !self.menuIsOpen && !self.inEditing){

			if(i < (level.ModelID.size-1))
				i++;
			else
				i=0;
			if(isDefined(level.Modelkit))
				level.Modelkit delete();
			
			vec=anglestoforward(self getPlayerAngles());
				end=(vec[0]*200,vec[1]*200,vec[2]*200);
				L=BulletTrace(self gettagorigin("tag_eye"),
				self gettagorigin("tag_eye")+end,0,self)["position"];
			level.Modelkit=spawn("script_model",L+(0,0,20)); 
			level.Modelkit.angles=self.angles; 
			level.Modelkit Solid(); 
			level.Modelkit.health=100;
			level.Modelkit.maxhealth=100;
			level.Modelkit setCanDamage(true);
			level.Modelkit thread monitorCrateHealth(self);
			
			level.Modelkit setModel(level.ModelID[i]); 
			self.TEXTTEST setText(i+": ^3"+level.ModelID[i]);
			level.SpawnEditorModel = level.ModelID[i];

			

			//self sayall("\n\n"+level.ModelID[i]+"\n\n");
		}
		else if(self isButtonPressed("+actionslot 3") && !self.menuIsOpen && !self.inEditing){

			if(i > 0)
				i--;
			else
				i=(level.ModelID.size-1);

			if(isDefined(level.Modelkit))
				level.Modelkit delete();
				
			vec=anglestoforward(self getPlayerAngles());
				end=(vec[0]*200,vec[1]*200,vec[2]*200);
				L=BulletTrace(self gettagorigin("tag_eye"),
				self gettagorigin("tag_eye")+end,0,self)["position"];
			level.Modelkit=spawn("script_model",L+(0,0,20)); 
			level.Modelkit.angles=self.angles; 
			level.Modelkit Solid(); 
			level.Modelkit.health=100;
			level.Modelkit.maxhealth=100;
			level.Modelkit setCanDamage(true);
			level.Modelkit thread monitorCrateHealth(self);
			
			level.Modelkit setModel(level.ModelID[i]); 
			self.TEXTTEST setText(i+": ^3"+level.ModelID[i]);
			level.SpawnEditorModel = level.ModelID[i];
		}
		else if(self isButtonPressed("+actionslot 2") && !self.menuIsOpen && !self.inEditing){
			if(isDefined(level.Modelkit))
				level.Modelkit delete();
		}
		wait 0.045;
		//wait 1;
		//iprintlnBold(level.ModelCount);
	}
}

monitorCrateHealth(player)
{
	while(1)
	{
		self waittill( "damage", damage, attacker, direction_vec, point, type, modelName, tagName, partName, iDFlags );
        iprintlnBold("Can Damage: "+ self.health);
	}
}

unfreezePlayer(){
	wait 1;
	self freezeControlsWrapper( false );
	self freezeControls( false );
	wait 4;
	self freezeControlsWrapper( false );
	self freezeControls( false );
}

myBunker()
{
	//Spawn location
	//self setorigin((1299, -2054, 200));
	setDvar("fx_enable", 0);
	setDvar("fx_draw", 0);
	setDvar("g_speed", 180);
	setDvar("stopspeed", 200);
	setDvar("jump_slowdownEnable", 0);

	//CreateElevator((-21088.6, 8107.66, -200.875),(-21773.6, 7613.97, 734.112)),((0, 0.398426, 0));

}

CreateWallTeleport(type, wallOrigin, exit, center)
{
	self endon("disconnect");
	while(1)
	{
		foreach(player in level.players)
		{
			if(player.origin[type] > wallOrigin && distance(player.origin, center) < 700){
				player setorigin((exit,player.origin[1],player.origin[2]+20));
			}
		}
		wait 0.025;
	}
}

CreateWallTeleport2(type, wallOrigin, exit, center)
{
	self endon("disconnect");
	while(1)
	{
		foreach(player in level.players)
		{
			if(player.origin[type] > wallOrigin){
				player setorigin((exit,player.origin[1],player.origin[2]+20));
			}
		}
		wait 0.025;
	}
}

CreateWallTeleport3(type, wallOrigin, exit, center)
{
	self endon("disconnect");
	while(1)
	{
		foreach(player in level.players)
		{
			if(player.origin[type] < wallOrigin){
				player setorigin((player.origin[0],exit,player.origin[2]+20));
			}
		}
		wait 0.025;
	}
}

CreateWallTeleport4(type, wallOrigin, exit, center)
{
	self endon("disconnect");
	while(1)
	{
		foreach(player in level.players)
		{
			if(player.origin[type] > wallOrigin){
				player setorigin((player.origin[0],exit,player.origin[2]+40));
			}
		}
		wait 0.025;
	}
}

//UFO begin//
tUFO()
{
	self endon("disconnect");
	self endon("death");
	self notifyOnPlayerCommand("melee","+melee_zoom");
	self thread newufonew();
	self iPrintlnBold("^3Crouch And [{+melee_zoom}] To Enable UFO");
	for(;;)
	{
        self waittill("melee");
        if(self GetStance()== "crouch")
		{
			self thread tUFO2();
		}
		wait 0.01;
	}
}

tUFO2()
{
	if(!self.IsUFO)
	{
		self.IsUFO=true;
		self iPrintlnBold("UFO Mode: ^5On");
		self.owp=self getWeaponsListOffhands();
		foreach(w in self.owp)self takeweapon(w);
		self.newufo.origin=self.origin;
		self playerlinkto(self.newufo);
	}
	else
	{
		self iPrintlnBold("UFO Mode: ^5Off");
		self.IsUFO=false;
		self unlink();
		foreach(w in self.owp)
            self _giveweapon(w);
	}
	wait 0.001;
}
Newufonew()
{
    if(isdefined(self.newufo))
	    self.newufo delete();
	
    self.newufo=spawn("script_origin",self.origin);
    self thread NewUFO();
}
NewUFO()
{
	self endon("disconnect");
	self endon("death");
	for(;;)
	{
		if(self.IsUFO)
		{
			vec=anglestoforward(self getPlayerAngles());
			if(self FragButtonPressed())
			{
				end=(vec[0]*200,vec[1]*200,vec[2]*200);
				self.newufo.origin=self.newufo.origin+end;
			}
			else if(self SecondaryOffhandButtonPressed())
			{
				end=(vec[0]*5,vec[1]*5,vec[2]*5);
				self.newufo.origin=self.newufo.origin+end;
			}
		}
		wait 0.05;
	}
}